<?php
session_start();

class pCaptcha
{
    var $pcap_fontsize;     //Schriftgrsse
    var $pcap_font;         //Schriftart (ttf)
    var $pcap_code;         //Der CODE
    var $pcap_len;          //Codelnge
    var $pcap_bg;           //Hintergrund

   	// PHP 5 Constructor
	function __construct( $pcap_code = "" )
 	{
		$this->pcap_code      = "";
		$this->pcap_font      = dirname(__FILE__)."/captcha.ttf";
		$this->pcap_bg        = dirname(__FILE__)."/captcha.png";
		$this->pcap_fontsize  = 24;
		$this->pcap_len       = 6;
		if ($this->pcap_code == "" ) {
            $this->newCode();
		} else {
		    $_SESSION['pcaptchacode'] = $this->pcap_code;
		}
	}

	// PHP 4 Contructor
	function pCaptcha( $pcap_code = "" )
	{
		$this->__construct( $pcap_code ) ;
	}

	function showCaptcha ()
	{
	    $img_format = 'png';

	    //Daten des BG
	    $imgsize = GetImageSize($this->pcap_bg);
        switch($imgsize[2]):
        case 1 : $bg = ImageCreateFromGIF($this->pcap_bg);
            break;
        case 2 : $bg = ImageCreateFromJPEG($this->pcap_bg);
            break;
        case 3 : $bg = ImageCreateFromPNG($this->pcap_bg);
            break;
        endswitch;

	    //Textgrsse
	    $pos = imagettfbbox($this->pcap_fontsize,0,$this->pcap_font,$this->pcap_code);
        $width  = intval(abs($pos[0])+abs($pos[2])+6);
        $height = intval(abs($pos[1]+$pos[7])+6);
        $posx   = 3;
        $posy   = $height - 3;
	    $pcap_im = imagecreatetruecolor($width,$height);
        imagecopyresampled($pcap_im,$bg,0,0,0,0,$width,$height,ImageSX($bg),ImageSY($bg));

	    //Text einfgen
    	// colors
    	$color_white    = imagecolorallocate($pcap_im, 0xFF, 0xFF, 0xFF);
    	$color_black    = imagecolorallocate($pcap_im, 0x00, 0x00, 0x00);
        imagettftext($pcap_im,$this->pcap_fontsize,0,$posx,$posy,$color_black,$this->pcap_font,$this->pcap_code);

        imageinterlace($pcap_im,false);

        $pcap_image = 'image'.$img_format;
    	// sending image
	    header('Content-type: image/'.$img_format);
        $pcap_image($pcap_im);
	}

	function newCode ()
	{
	    if ( !isset($_SESSION['pcaptchacode']) ) {
	        $iid= md5(uniqid(rand()));
	        $iid= substr($iid,0,$this->pcap_len);
	        $_SESSION['pcaptchacode'] = $iid;
	        $this->pcap_code = $iid;
	    } else {
	        $this->pcap_code = $_SESSION['pcaptchacode'];
	    }
	}
	function delCode()
	{
	    if ( isset($_SESSION['pcaptchacode']) ) {
	        unset ( $_SESSION['pcaptchacode'] );
	    }
	}
}

$pc = new pCaptcha();
//echo $pc->pcap_code;
$pc->showCaptcha();
?>