<?php
//##############################################################################
//## pGB Funktionen                                                           ##
//## Thomas Ehrhardt                                                          ##
//## www.powie.de                                                             ##
//##############################################################################

if(!function_exists('formatpost')) {
    function formatpost($post)
    {
        $post= stripslashes($post);
        $post= htmlspecialchars($post);
        //$post= nl2br($post);

        //Smileys:
        //str_replace("altes-zeichen","neues-zeichen","zeichenkette");
        $post = str_replace(":-)","<img border=\"0\" src=\"smile01.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(";-)","<img border=\"0\" src=\"smile02.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(":O","<img border=\"0\" src=\"smile03.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(";-(","<img border=\"0\" src=\"smile04.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(":D","<img border=\"0\" src=\"smile05.gif\" alt=\"s\" /> ",$post);
        $post = str_replace("8-)","<img border=\"0\" src=\"smile06.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(":-O","<img border=\"0\" src=\"smile07.gif\" alt=\"s\" /> ",$post);
        $post = str_replace(":-(","<img border=\"0\" src=\"smile08.gif\" alt=\"s\" /> ",$post);
        $post = str_replace("(?)","<img border=\"0\" src=\"smile09.gif\" alt=\"s\" /> ",$post);
        $post = str_replace("(!)","<img border=\"0\" src=\"smile10.gif\" alt=\"s\" /> ",$post);

        // URLS in HRC umwandeln:
        $post=eregi_replace("([ \r\n])http://([^ ,\r\n]*)","\\1[url]http://\\2[/url]",$post);
        $post=eregi_replace("([ \r\n])https://([^ ,\r\n]*)","\\1[url]https://\\2[/url]",$post);
        $post=eregi_replace("([ \r\n])ftp://([^ ,\r\n]*)","\\1[url]ftp://\\2[/url]",$post);
        $post=eregi_replace("([ \r\n])www\\.([^ ,\r\n]*)","\\1[url]http://www.\\2[/url]",$post);
        $post=eregi_replace("^http://([^ ,\r\n]*)","[url]http://\\1[/url]",$post);
        $post=eregi_replace("^https://([^ ,\r\n]*)","[url]https://\\1[/url]",$post);
        $post=eregi_replace("^ftp://([^ ,\r\n]*)","[url]ftp://\\1[/url]",$post);
        $post=eregi_replace("^www\\.([^ ,\r\n]*)","[url]http://www.\\1[/url]",$post);

        // ######### HRC Codes:
        $post = str_replace("[hr]","<hr>",$post);
        $post = str_replace("[b]","<b>",$post);
        $post = str_replace("[/b]","</b>",$post);
        $post = str_replace("[i]","<i>",$post);
        $post = str_replace("[/i]","</i>",$post);
        $post = str_replace("[img]","<img border=0 src=",$post);
        $post = str_replace("[/img]","> ",$post);

        // [URL]
        $post=eregi_replace("\\[url\\]www.([^\\[]*)\\[/url\\]","<a href=\"http://www.\\1\" target=_blank>\\1</a>",$post);
        $post=eregi_replace("\\[url\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" target=_blank>\\1</a>",$post);

        // [URL=
        $post=eregi_replace("\\[url=\"([^\"]*)\"\\]([^\\[]*)\\[\\/url\\]","<a href=\"\\1\" target=_blank>\\2</a>",$post);
        $post=eregi_replace("\\[url=([^\"]*)\\]([^\\[]*)\\[\\/url\\]","<a href=\"\\1\" target=_blank>\\2</a>",$post);
        $post=eregi_replace("\\[email\\]([^\\[]*)\\[/email\\]","<a href=\"mailto:\\1\">\\1</a>",$post);

        // ########## Ende HRC Codes
        $post= nl2br($post);
        return $post;
    }
}

if(!function_exists('formatstring')) {
    function formatstring($post)
    {
        $post= stripslashes($post);
        $post= htmlspecialchars($post);
        return $post;
    }
}

if(!function_exists('pfilter_input')) {
        function pfilter_input($input,$typ="text")
        {
            //Typen: int,text
            if ($typ="int") {
                $result = intval($input);
            }
            elseif ( $typ="text") {
                $result=htmlspecialchars($input);
            }
            return $result;
        }
}

if (!function_exists('PageSwitcher')) {
function PageSwitcher($eintragaktuell, $zps, $gesamt, $linkstring) {
	$maxsites = 10;
	$eintrag="0";
	$seite="1";
	$seitenanzeige = "Seite: ";
	$eintrag=$eintragaktuell;
	$aktseite=($eintragaktuell+$zps)/$zps;
	$seite = $aktseite-$maxsites;
	if ($seite < 1) {
		$seite = 1;
	}
	$eintrag = ($seite*$zps)-$zps;
	if ($seite < 1) {
	    $seite = 1;
	}
	if ($seite > 1) {
	    $seitenanzeige= $seitenanzeige."$linkstring=0\">1</a> << ";
	}
	while ($eintrag < $gesamt) {
		//$bis = $eintrag+$tps;
	    if ($eintrag==$eintragaktuell) {
	    	$seitenanzeige= $seitenanzeige." <b>[$seite]</b> ";
		} else {
	        $seitenanzeige= $seitenanzeige." $linkstring=$eintrag\">$seite</a>";
		}
	    $eintrag = ($eintrag+$zps);
	    $seite = $seite+1;
	    if ($seite > ($aktseite+$maxsites)) {
	        $seitenanzeige= $seitenanzeige." >> ";
	        break;
	    }
	}
	$lastpage=ceil($gesamt/$zps);
	$eintrag=($lastpage*$zps)-$zps;
	if ($lastpage > $seite) {
	    $seitenanzeige=$seitenanzeige." $linkstring=$eintrag\">$lastpage</a>";
	}
	return $seitenanzeige;
} //Ende PageSwitcher
}


if(!function_exists('isemail')) {
    function isemail ($mail)
    {
        if (!eregi("^[\&_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$",$mail)) {
            $ismail = 0;
            # Mailadresse sieht seltsam aus
        } else {
            $ismail=1;
        }
        return $ismail;
    }
}

if(!function_exists('checkwordlength')) {
    function checkwordlength ($text)
    {
        $text=formatpost($text);
        global $maxwordlength;
        $zulang = FALSE;
        foreach(explode(" ",str_replace("\n"," ",$text)) as $word) {
            if (strlen($word)>$maxwordlength) {
                $zulang=TRUE;
            }
        }
        return $zulang;
    }
}

if (!function_exists('msgBox')) {
    function msgBox($text)
    {
        global $gbname;
        echo "<div align=\"center\"><table border=\"0\" cellspacing=\"1\" cellpadding=\"2\" width=\"80%\" class=\"info\">
              <tr><th class=\"head\">".PGBL_guestbook." ".PGBL_info."</th></tr>
              <tr><td align=\"center\" class=\"left\">$text</td></tr></table></div>";
    }
}

if (!class_exists('Template')) {
class Template
{
	function Template($ptTPLFile) 	{
		global $tpldir;
		$ptTPLFile = $tpldir.$ptTPLFile;
        if( !file_exists($ptTPLFile) )
		{
			$this->Stop("TPL File nicht auffindbar: " . $ptTPLFile );
		}
		$this->ptTPLData = @implode('', (@file($ptTPLFile)));
		$this->ptTPLData = str_replace('"', '\"', $this->ptTPLData);
	}
	function TemplateVar($ptVarName ) 	{
		return ('$' . $ptVarName . ' .= "' . $this->ptTPLData . '";');
    }
    function Stop($ptErrorMsg) 	{
		echo "<pre>PTemplate error: " . $ptErrorMsg . "</pre>";
		exit;
	}
}
}

if (!function_exists('infilter')) {
function infilter($var,$typ,$method='POST')
    {
		//nach Methode einlesen
		if ( $method == 'POST' ) {
			$var = $_POST[$var];
		}
		if ( $method == 'GET' ) {
			$var = $_GET[$var];
		}
		if ( $method == 'REQUEST' ) {
			$var = $_REQUEST[$var];
		}

		//nach Filtertyp verarbeiten
		if ( $typ == 'INT' ) {
			$var = intval($var);
		}
		if ( $typ == 'TXT' ) {
			$var = htmlspecialchars($var);
		}
		if ( $typ == 'URL' ) {
			$var = strip_tags($var);
			$var = str_replace("javascript","java_script",$var);
		}

		//generelle Filterungen
		//$var = str_replace("javascript","java_script",$var);

		return $var;
}
}

?>